<?php

namespace App\Models\Subscription;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subscription extends Model 
{

    protected $table = 'subscriptions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('plan_id', 'user_id', 'amount_paid', 'start_date', 'end_date');

    public function palns()
    {
        return $this->belongsTo('Plans', 'plan_id');
    }

}